﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Ball : MonoBehaviour {
    public float intensity;
    private Rigidbody2D rb2d;
    public float MaxVelocity ;
    public float MaxDownward;
    public AudioClip jumpBall;
    
   
	void Start () {
        rb2d = GetComponent<Rigidbody2D>();
        InitializeColor();
        

    }

    // Update is called once per frame
    void FixedUpdate ()
    {
        if (Input.GetMouseButtonDown(0))
        {
            if (rb2d != null)
            {    
                rb2d.AddForce(Vector2.up * intensity );
                AudioSource.PlayClipAtPoint(jumpBall, transform.position);
            }
        }
        if (rb2d.velocity.y > MaxVelocity) // da onemoguci lopti da skace previsoko
        { 
            rb2d.AddForce(Vector2.down * 30);
        }
        
        if (rb2d.velocity.y <  MaxDownward) // max velocity kada pada y ispod 0 dokle moze da pada
        {
            rb2d.AddForce(Vector2.up * intensity);
        }
    }

    void InitializeColor()
    {
        MenagerReferences refs = GameObject.Find("Menager").GetComponent<MenagerReferences>();
        if (refs!=null)
        {
            int colorCount = refs.Colors.Length;
            int randomIndex = Random.Range(0,colorCount-1);
            Color newColor = refs.Colors[randomIndex];
            SpriteRenderer render = GetComponent<SpriteRenderer>();
            render.color = newColor;
           
        }
    }
  

    }
